﻿' “项详细信息页”项模板在 http://go.microsoft.com/fwlink/?LinkId=234232 上提供

''' <summary>
''' 显示组内单一项的详细信息同时允许使用手势
''' 浏览同一组的其他项的页。
''' </summary>
Public NotInheritable Class ItemDetailPage
    Inherits Page

    ''' <summary>
    ''' NavigationHelper 在每页上用于协助导航和
    ''' 进程生命期管理
    ''' </summary>
    Public ReadOnly Property NavigationHelper As Common.NavigationHelper
        Get
            Return Me._navigationHelper
        End Get
    End Property
    Private _navigationHelper As Common.NavigationHelper

    ''' <summary>
    ''' 可将其更改为强类型视图模型。
    ''' </summary>
    Public ReadOnly Property DefaultViewModel As Common.ObservableDictionary
        Get
            Return Me._defaultViewModel
        End Get
    End Property
    Private _defaultViewModel As New Common.ObservableDictionary()


    Public Sub New()
        InitializeComponent()
        Me._navigationHelper = New Common.NavigationHelper(Me)
        AddHandler Me._navigationHelper.LoadState,
            AddressOf NavigationHelper_LoadState
    End Sub

    ''' <summary>
    ''' 使用在导航过程中传递的内容填充页。  在从以前的会话
    ''' 重新创建页时，也会提供任何已保存状态。
    ''' </summary>
    ''' <param name="sender">
    ''' 事件的来源; 通常为 <see cref="NavigationHelper"/>
    ''' </param>
    ''' <param name="e">事件数据，其中既提供在最初请求此页时传递给
    ''' <see cref="Frame.Navigate"/> 的导航参数，又提供
    ''' 此页在以前会话期间保留的状态的
    ''' 字典。 首次访问页面时，该状态将为 null。</param>
    Private Async Sub NavigationHelper_LoadState(sender As Object, e As Common.LoadStateEventArgs)
        ' TODO:  创建适用于问题域的合适数据模型以替换示例数据
        Dim item As Data.SampleDataItem = Await Data.SampleDataSource.GetItemAsync(DirectCast(e.NavigationParameter, String))
        Me.DefaultViewModel("Item") = item
    End Sub

#Region "NavigationHelper 注册"

    ''' 此部分中提供的方法只是用于使
    ''' NavigationHelper 可响应页面的导航方法。
    ''' 
    ''' 应将页面特有的逻辑放入用于
    ''' <see cref="Common.NavigationHelper.LoadState"/>
    ''' 和 <see cref="Common.NavigationHelper.SaveState"/> 的事件处理程序中。
    ''' 除了在会话期间保留的页面状态之外
    ''' LoadState 方法中还提供导航参数。

    Protected Overrides Sub OnNavigatedTo(e As NavigationEventArgs)
        _navigationHelper.OnNavigatedTo(e)
    End Sub

    Protected Overrides Sub OnNavigatedFrom(e As NavigationEventArgs)
        _navigationHelper.OnNavigatedFrom(e)
    End Sub
#End Region
End Class
